import org.pgusb.usbDllAdapter.ReadBytes;
import org.pgusb.usbDllAdapter.WriteBytes;
import org.pgusb.usbDllAdapter.UsbDllAdapter;

public class test {
	static final int MP_WRITE=0;
	static final int MP_READ=1;
	static final int INVALID_HANDLE_VALUE=-1;
	static final String vid_pid= "vid_04d8&pid_000c";
	static final int HEADER_LENGTH=3;


	static public ReadBytes SendReceivePacket(int myOutPipe, int myInPipe,byte[] SendData, int SendLength,
			int ReceiveLength,int SendDelay, int ReceiveDelay) {

		int ExpectedReceiveLength = ReceiveLength; 

		if(myOutPipe != INVALID_HANDLE_VALUE && myInPipe != INVALID_HANDLE_VALUE){
			try {
				WriteBytes wb = UsbDllAdapter.MPUSBWrite(myOutPipe,SendData,SendLength,SendDelay);
				System.out.println("Quiero write: " + SendLength + " Writed Bytes : "+ wb.getLength()+ " retval: "+ wb.getRetVal());
				if (wb.getRetVal()!=0) {
					ReadBytes rb = UsbDllAdapter.MPUSBRead(myInPipe, ExpectedReceiveLength,ReceiveDelay);
					System.out.println("Read Bytes : "+ rb.getLength()+ " retval: "+ rb.getRetVal());
					if(rb.getRetVal()!=0) {
						if(rb.getLength() == ExpectedReceiveLength){
							return new ReadBytes(rb.getReadBytes(),rb.getLength(),1);   // Success!
						}
						else if(rb.getLength() < ExpectedReceiveLength)
						{
							return new ReadBytes(rb.getReadBytes(),rb.getLength(),2);   // Partially failed, incorrect receive length
						}//end if else
					}
				}
			}//end if
			catch (Exception e){
				System.out.println("Excepcion en SendReceivePacket");
			}
		}
		return new ReadBytes(null,0,-1);  // Operation Failed
	}//end SendReceivePacket


	static void GetUSBDemoFWVersionH1() {
		// First we need to open data pipes...
		//TODO sacar hardcode de selection
		int selection=0; 
		String out_pipe= "\\MCHP_EP1";
		String in_pipe= "\\MCHP_EP1";
		int myOutPipe=-1;
		int myInPipe=-1;
		try {
			myOutPipe = UsbDllAdapter.MPUSBOpen(selection,vid_pid,out_pipe,MP_WRITE,0);
			myInPipe = UsbDllAdapter.MPUSBOpen(selection,vid_pid,out_pipe,MP_READ,0);
		} catch (Exception e){
			System.out.println(e.getMessage());
		}
		if(myOutPipe == INVALID_HANDLE_VALUE || myInPipe == INVALID_HANDLE_VALUE)
		{
			System.out.println("Failed to open data pipes.\r\n");
			return;
		}//end if

		System.out.println("myOutPipe: "+ myOutPipe + " myInPipe:" + myInPipe);

		// The default demo firmware application has a defined application
		// level protocol.
		// To read the firmware version, the host must send the READ_VERSION
		// command which is defined as 0x00, follows by the length of the
		// expected result, in this case is 2 bytes, major version, and minor
		// version.
		// i.e. <READ_VERSION><0x02>
		//
		// The response packet from the board has the following format:
		// <READ_VERSION><0x02><MINOR_VER><MAJOR_VER>

		// The receive buffer size must be equal to or larger than the maximum
		// endpoint size it is communicating with. In this case, 64 bytes.

		//BYTE send_buf[64],receive_buf[64];
		int RecvLength=7;
		int READ_VERSION=0;
		StringBuffer receive_buf = new StringBuffer(64);
		StringBuffer send_buf= new StringBuffer(64);
		//send_buf[0] = READ_VERSION;      // Command
		//send_buf[1] = 0x02;              // Expected length of the result

		send_buf.append((char)0x08);		//HEADER
		send_buf.append((char)0x00);		//HEADER
		send_buf.append((char)0x00);		//HEADER

		send_buf.append((char)0x00);
		send_buf.append((char)0x02);
		//System.out.println(send_buf.toString());
		ReadBytes rb =SendReceivePacket(myOutPipe,myInPipe,send_buf.toString().getBytes(),send_buf.toString().length(),RecvLength,1000,1000);
		if(rb.getRetVal() == 1)
		{
			System.out.println("Read Bytes : "+ rb.getLength()+ " retval: "+ rb.getRetVal());
			for (int i =0 ; i<rb.getLength() ; i++){
				System.out.print((int)rb.getReadBytes()[i]);
				System.out.print(" ");
			}
			System.out.println(" ");
			//System.out.println("String: " + rb.getString() +" Read Bytes : "+ rb.getLength()+ " retval: "+ rb.getRetVal());
			/*debe retornar esto:
			 * Read Bytes : 4 retval: 1
			  	0 2 11 0  
			 */
			if(RecvLength == 4+HEADER_LENGTH && rb.getReadBytes()[0+HEADER_LENGTH] == READ_VERSION &&
					rb.getReadBytes()[1+HEADER_LENGTH] == 0x02)
			{
				System.out.println("USB Demo Firmware Version " + rb.getReadBytes()[3+HEADER_LENGTH] +"."+
						rb.getReadBytes()[2+HEADER_LENGTH]);
			}
		}
		// tener en cuenta esta clase para manejo de bytes MappedByteBuffer
		else {
			System.out.println("USB Operation Failed\r\n");
			System.out.println("return: " + rb.getReadBytes() + " length:" + rb.getLength() + " ret:" +rb.getRetVal() );
		}
		// Let's close the data pipes since we have nothing left to do..
		try {

			UsbDllAdapter.MPUSBClose(myOutPipe);
			UsbDllAdapter.MPUSBClose(myInPipe);
		}
		catch (Exception e){
			System.out.println("error a hacer el close");
			System.out.println(e.getMessage());
		}
		myOutPipe = myInPipe = INVALID_HANDLE_VALUE;
	}


	static void GetUSBDemoFWVersionH2() {
		// First we need to open data pipes...
		//TODO sacar hardcode de selection
		int selection=0; 
		String out_pipe= "\\MCHP_EP1";
		String in_pipe= "\\MCHP_EP1";
		int myOutPipe=-1;
		int myInPipe=-1;
		try {
			myOutPipe = UsbDllAdapter.MPUSBOpen(selection,vid_pid,out_pipe,MP_WRITE,0);
			myInPipe = UsbDllAdapter.MPUSBOpen(selection,vid_pid,out_pipe,MP_READ,0);
		} catch (Exception e){
			System.out.println(e.getMessage());
		}
		if(myOutPipe == INVALID_HANDLE_VALUE || myInPipe == INVALID_HANDLE_VALUE)
		{
			System.out.println("Failed to open data pipes.\r\n");
			return;
		}//end if

		System.out.println("myOutPipe: "+ myOutPipe + " myInPipe:" + myInPipe);

		// The default demo firmware application has a defined application
		// level protocol.
		// To read the firmware version, the host must send the READ_VERSION
		// command which is defined as 0x00, follows by the length of the
		// expected result, in this case is 2 bytes, major version, and minor
		// version.
		// i.e. <READ_VERSION><0x02>
		//
		// The response packet from the board has the following format:
		// <READ_VERSION><0x02><MINOR_VER><MAJOR_VER>

		// The receive buffer size must be equal to or larger than the maximum
		// endpoint size it is communicating with. In this case, 64 bytes.

		//BYTE send_buf[64],receive_buf[64];
		int RecvLength=7;
		int READ_VERSION=0;
		StringBuffer receive_buf = new StringBuffer(64);
		StringBuffer send_buf= new StringBuffer(64);
		//send_buf[0] = READ_VERSION;      // Command
		//send_buf[1] = 0x02;              // Expected length of the result

		send_buf.append((char)0x10);		//HEADER
		send_buf.append((char)0x00);		//HEADER
		send_buf.append((char)0x00);		//HEADER

		send_buf.append((char)0x00);
		send_buf.append((char)0x02);
		//System.out.println(send_buf.toString());
		ReadBytes rb =SendReceivePacket(myOutPipe,myInPipe,send_buf.toString().getBytes(),send_buf.toString().length(),RecvLength,1000,1000);
		if(rb.getRetVal() == 1)
		{
			System.out.println("Read Bytes : "+ rb.getLength()+ " retval: "+ rb.getRetVal());
			for (int i =0 ; i<rb.getLength() ; i++){
				System.out.print((int)rb.getReadBytes()[i]);
				System.out.print(" ");
			}
			System.out.println(" ");
			//System.out.println("String: " + rb.getString() +" Read Bytes : "+ rb.getLength()+ " retval: "+ rb.getRetVal());
			/*debe retornar esto:
			 * Read Bytes : 4 retval: 1
			  	0 2 11 0  
			 */
			if(RecvLength == 4+HEADER_LENGTH && rb.getReadBytes()[0+HEADER_LENGTH] == READ_VERSION &&
					rb.getReadBytes()[1+HEADER_LENGTH] == 0x02)
			{
				System.out.println("USB Demo Firmware Version " + rb.getReadBytes()[3+HEADER_LENGTH] +"."+
						rb.getReadBytes()[2+HEADER_LENGTH]);
			}
		}
		// tener en cuenta esta clase para manejo de bytes MappedByteBuffer
		else {
			System.out.println("USB Operation Failed\r\n");
			System.out.println("return: " + rb.getReadBytes() + " length:" + rb.getLength() + " ret:" +rb.getRetVal() );
		}
		// Let's close the data pipes since we have nothing left to do..
		try {

			UsbDllAdapter.MPUSBClose(myOutPipe);
			UsbDllAdapter.MPUSBClose(myInPipe);
		}
		catch (Exception e){
			System.out.println("error a hacer el close");
			System.out.println(e.getMessage());
		}
		myOutPipe = myInPipe = INVALID_HANDLE_VALUE;
	}

	
	
	
	
	static void OpenTemp() {
		// First we need to open data pipes...
		//TODO sacar hardcode de selection
		int selection=0; 
		String out_pipe= "\\MCHP_EP1";
		String in_pipe= "\\MCHP_EP1";
		int myOutPipe=-1;
		int myInPipe=-1;
		try {
			myOutPipe = UsbDllAdapter.MPUSBOpen(selection,vid_pid,out_pipe,MP_WRITE,0);
			myInPipe = UsbDllAdapter.MPUSBOpen(selection,vid_pid,out_pipe,MP_READ,0);
		} catch (Exception e){
			System.out.println(e.getMessage());
		}
		if(myOutPipe == INVALID_HANDLE_VALUE || myInPipe == INVALID_HANDLE_VALUE)
		{
			System.out.println("Failed to open data pipes.\r\n");
			return;
		}//end if

		System.out.println("myOutPipe: "+ myOutPipe + " myInPipe:" + myInPipe);

		// The default demo firmware application has a defined application
		// level protocol.
		// To read the firmware version, the host must send the READ_VERSION
		// command which is defined as 0x00, follows by the length of the
		// expected result, in this case is 2 bytes, major version, and minor
		// version.
		// i.e. <READ_VERSION><0x02>
		//
		// The response packet from the board has the following format:
		// <READ_VERSION><0x02><MINOR_VER><MAJOR_VER>

		// The receive buffer size must be equal to or larger than the maximum
		// endpoint size it is communicating with. In this case, 64 bytes.

		//BYTE send_buf[64],receive_buf[64];
		int RecvLength=5;
		int READ_VERSION=0;
		StringBuffer receive_buf = new StringBuffer(64);
		StringBuffer send_buf= new StringBuffer(64);
		//send_buf[0] = READ_VERSION;      // Command
		//send_buf[1] = 0x02;              // Expected length of the result

		send_buf.append((char)0x00);		//HEADER
		send_buf.append((char)0x04);		//HEADER
		send_buf.append((char)0x00);		//HEADER

		send_buf.append((char)0x00);
		send_buf.append((char)0x01);
		send_buf.append((char)0x01);
		send_buf.append((char)'t');
		send_buf.append((char)'e');
		send_buf.append((char)'m');
		send_buf.append((char)'p');
		send_buf.append((char)'\0');
		//System.out.println(send_buf.toString());
		ReadBytes rb =SendReceivePacket(myOutPipe,myInPipe,send_buf.toString().getBytes(),send_buf.toString().length(),RecvLength,1000,1000);
		if(rb.getRetVal() == 1)
		{
			System.out.println("Read Bytes : "+ rb.getLength()+ " retval: "+ rb.getRetVal());
			for (int i =0 ; i<rb.getLength() ; i++){
				System.out.print((int)rb.getReadBytes()[i]);
				System.out.print(" ");
			}
			System.out.println(" ");
			//System.out.println("String: " + rb.getString() +" Read Bytes : "+ rb.getLength()+ " retval: "+ rb.getRetVal());
			/*debe retornar esto:
			 * Read Bytes : 4 retval: 1
			  	0 2 11 0  
			 */
			System.out.println("Handler Number: " + rb.getReadBytes()[1+HEADER_LENGTH]);
		}

		// tener en cuenta esta clase para manejo de bytes MappedByteBuffer
		else {
			System.out.println("USB Operation Failed\r\n");
			System.out.println("return: " + rb.getReadBytes() + " length:" + rb.getLength() + " ret:" +rb.getRetVal() );
		}
		// Let's close the data pipes since we have nothing left to do..
		try {

			UsbDllAdapter.MPUSBClose(myOutPipe);
			UsbDllAdapter.MPUSBClose(myInPipe);
		}
		catch (Exception e){
			System.out.println("error a hacer el close");
			System.out.println(e.getMessage());
		}
		myOutPipe = myInPipe = INVALID_HANDLE_VALUE;
	}
	static void OpenMotor() {
		// First we need to open data pipes...
		//TODO sacar hardcode de selection
		int selection=0; 
		String out_pipe= "\\MCHP_EP1";
		String in_pipe= "\\MCHP_EP1";
		int myOutPipe=-1;
		int myInPipe=-1;
		try {
			myOutPipe = UsbDllAdapter.MPUSBOpen(selection,vid_pid,out_pipe,MP_WRITE,0);
			myInPipe = UsbDllAdapter.MPUSBOpen(selection,vid_pid,out_pipe,MP_READ,0);
		} catch (Exception e){
			System.out.println(e.getMessage());
		}
		if(myOutPipe == INVALID_HANDLE_VALUE || myInPipe == INVALID_HANDLE_VALUE)
		{
			System.out.println("Failed to open data pipes.\r\n");
			return;
		}//end if

		System.out.println("myOutPipe: "+ myOutPipe + " myInPipe:" + myInPipe);

		// The default demo firmware application has a defined application
		// level protocol.
		// To read the firmware version, the host must send the READ_VERSION
		// command which is defined as 0x00, follows by the length of the
		// expected result, in this case is 2 bytes, major version, and minor
		// version.
		// i.e. <READ_VERSION><0x02>
		//
		// The response packet from the board has the following format:
		// <READ_VERSION><0x02><MINOR_VER><MAJOR_VER>

		// The receive buffer size must be equal to or larger than the maximum
		// endpoint size it is communicating with. In this case, 64 bytes.

		//BYTE send_buf[64],receive_buf[64];
		int RecvLength=5;
		int READ_VERSION=0;
		StringBuffer receive_buf = new StringBuffer(64);
		StringBuffer send_buf= new StringBuffer(64);
		//send_buf[0] = READ_VERSION;      // Command
		//send_buf[1] = 0x02;              // Expected length of the result

		send_buf.append((char)0x00);		//HEADER
		send_buf.append((char)0x04);		//HEADER
		send_buf.append((char)0x00);		//HEADER

		send_buf.append((char)0x00);
		send_buf.append((char)0x01);
		send_buf.append((char)0x01);
		send_buf.append((char)'m');
		send_buf.append((char)'o');
		send_buf.append((char)'t');
		send_buf.append((char)'o');
		send_buf.append((char)'r');
//		send_buf.append((char)'\0');
		//System.out.println(send_buf.toString());
		ReadBytes rb =SendReceivePacket(myOutPipe,myInPipe,send_buf.toString().getBytes(),send_buf.toString().length(),RecvLength,1000,1000);
		if(rb.getRetVal() == 1)
		{
			System.out.println("Read Bytes : "+ rb.getLength()+ " retval: "+ rb.getRetVal());
			for (int i =0 ; i<rb.getLength() ; i++){
				System.out.print((int)rb.getReadBytes()[i]);
				System.out.print(" ");
			}
			System.out.println(" ");
			//System.out.println("String: " + rb.getString() +" Read Bytes : "+ rb.getLength()+ " retval: "+ rb.getRetVal());
			/*debe retornar esto:
			 * Read Bytes : 4 retval: 1
			  	0 2 11 0  
			 */
			System.out.println("Handler Number: " + rb.getReadBytes()[1+HEADER_LENGTH]);
		}

		// tener en cuenta esta clase para manejo de bytes MappedByteBuffer
		else {
			System.out.println("USB Operation Failed\r\n");
			System.out.println("return: " + rb.getReadBytes() + " length:" + rb.getLength() + " ret:" +rb.getRetVal() );
		}
		// Let's close the data pipes since we have nothing left to do..
		try {

			UsbDllAdapter.MPUSBClose(myOutPipe);
			UsbDllAdapter.MPUSBClose(myInPipe);
		}
		catch (Exception e){
			System.out.println("error a hacer el close");
			System.out.println(e.getMessage());
		}
		myOutPipe = myInPipe = INVALID_HANDLE_VALUE;
	}

	
	static void OpenBoot() {
		// First we need to open data pipes...
		//TODO sacar hardcode de selection
		int selection=0; 
		String out_pipe= "\\MCHP_EP1";
		String in_pipe= "\\MCHP_EP1";
		int myOutPipe=-1;
		int myInPipe=-1;
		try {
			myOutPipe = UsbDllAdapter.MPUSBOpen(selection,vid_pid,out_pipe,MP_WRITE,0);
			myInPipe = UsbDllAdapter.MPUSBOpen(selection,vid_pid,out_pipe,MP_READ,0);
		} catch (Exception e){
			System.out.println(e.getMessage());
		}
		if(myOutPipe == INVALID_HANDLE_VALUE || myInPipe == INVALID_HANDLE_VALUE)
		{
			System.out.println("Failed to open data pipes.\r\n");
			return;
		}//end if

		System.out.println("myOutPipe: "+ myOutPipe + " myInPipe:" + myInPipe);

		// The default demo firmware application has a defined application
		// level protocol.
		// To read the firmware version, the host must send the READ_VERSION
		// command which is defined as 0x00, follows by the length of the
		// expected result, in this case is 2 bytes, major version, and minor
		// version.
		// i.e. <READ_VERSION><0x02>
		//
		// The response packet from the board has the following format:
		// <READ_VERSION><0x02><MINOR_VER><MAJOR_VER>

		// The receive buffer size must be equal to or larger than the maximum
		// endpoint size it is communicating with. In this case, 64 bytes.

		//BYTE send_buf[64],receive_buf[64];
		int RecvLength=5;
		int READ_VERSION=0;
		StringBuffer receive_buf = new StringBuffer(64);
		StringBuffer send_buf= new StringBuffer(64);
		//send_buf[0] = READ_VERSION;      // Command
		//send_buf[1] = 0x02;              // Expected length of the result

		send_buf.append((char)0x00);		//HEADER
		send_buf.append((char)0x04);		//HEADER
		send_buf.append((char)0x00);		//HEADER

		send_buf.append((char)0x00);
		send_buf.append((char)0x01);
		send_buf.append((char)0x01);
		send_buf.append((char)'2');
		send_buf.append((char)'t');
		send_buf.append((char)'e');
		send_buf.append((char)'m');
		send_buf.append((char)'p');
		
		//System.out.println(send_buf.toString());
		ReadBytes rb =SendReceivePacket(myOutPipe,myInPipe,send_buf.toString().getBytes(),send_buf.toString().length(),RecvLength,1000,1000);
		if(rb.getRetVal() == 1)
		{
			System.out.println("Read Bytes : "+ rb.getLength()+ " retval: "+ rb.getRetVal());
			for (int i =0 ; i<rb.getLength() ; i++){
				System.out.print((int)rb.getReadBytes()[i]);
				System.out.print(" ");
			}
			System.out.println(" ");
			//System.out.println("String: " + rb.getString() +" Read Bytes : "+ rb.getLength()+ " retval: "+ rb.getRetVal());
			/*debe retornar esto:
			 * Read Bytes : 4 retval: 1
			  	0 2 11 0  
			 */
			System.out.println("Handler Number: " + rb.getReadBytes()[1+HEADER_LENGTH] +" Out Endpoint Nnumber: "+
					rb.getReadBytes()[2+HEADER_LENGTH]);
		}

		// tener en cuenta esta clase para manejo de bytes MappedByteBuffer
		else {
			System.out.println("USB Operation Failed\r\n");
			System.out.println("return: " + rb.getReadBytes() + " length:" + rb.getLength() + " ret:" +rb.getRetVal() );
		}
		// Let's close the data pipes since we have nothing left to do..
		try {

			UsbDllAdapter.MPUSBClose(myOutPipe);
			UsbDllAdapter.MPUSBClose(myInPipe);
		}
		catch (Exception e){
			System.out.println("error a hacer el close");
			System.out.println(e.getMessage());
		}
		myOutPipe = myInPipe = INVALID_HANDLE_VALUE;
	}


	
	
	static void Close(int handler) {
		// First we need to open data pipes...
		//TODO sacar hardcode de selection
		int selection=0; 
		String out_pipe= "\\MCHP_EP1";
		String in_pipe= "\\MCHP_EP1";
		int myOutPipe=-1;
		int myInPipe=-1;
		try {
			myOutPipe = UsbDllAdapter.MPUSBOpen(selection,vid_pid,out_pipe,MP_WRITE,0);
			myInPipe = UsbDllAdapter.MPUSBOpen(selection,vid_pid,out_pipe,MP_READ,0);
		} catch (Exception e){
			System.out.println(e.getMessage());
		}
		if(myOutPipe == INVALID_HANDLE_VALUE || myInPipe == INVALID_HANDLE_VALUE)
		{
			System.out.println("Failed to open data pipes.\r\n");
			return;
		}//end if

		System.out.println("myOutPipe: "+ myOutPipe + " myInPipe:" + myInPipe);

		// The default demo firmware application has a defined application
		// level protocol.
		// To read the firmware version, the host must send the READ_VERSION
		// command which is defined as 0x00, follows by the length of the
		// expected result, in this case is 2 bytes, major version, and minor
		// version.
		// i.e. <READ_VERSION><0x02>
		//
		// The response packet from the board has the following format:
		// <READ_VERSION><0x02><MINOR_VER><MAJOR_VER>

		// The receive buffer size must be equal to or larger than the maximum
		// endpoint size it is communicating with. In this case, 64 bytes.

		//BYTE send_buf[64],receive_buf[64];
		int RecvLength=5;  // <header><op_type><result>
		int READ_VERSION=0;
		StringBuffer receive_buf = new StringBuffer(64);
		StringBuffer send_buf= new StringBuffer(64);
		//send_buf[0] = READ_VERSION;      // Command
		//send_buf[1] = 0x02;              // Expected length of the result

		send_buf.append((char)0x00);		//HEADER
		send_buf.append((char)0x05);		//HEADER
		send_buf.append((char)0x00);		//HEADER

		send_buf.append((char)0x01);
		send_buf.append((char)handler);
		//System.out.println(send_buf.toString());
		ReadBytes rb =SendReceivePacket(myOutPipe,myInPipe,send_buf.toString().getBytes(),send_buf.toString().length(),RecvLength,1000,1000);
		if(rb.getRetVal() == 1)
		{
			System.out.println("Read Bytes : "+ rb.getLength()+ " retval: "+ rb.getRetVal());
			for (int i =0 ; i<rb.getLength() ; i++){
				System.out.print((int)rb.getReadBytes()[i]);
				System.out.print(" ");
			}
			System.out.println(" ");
			//System.out.println("String: " + rb.getString() +" Read Bytes : "+ rb.getLength()+ " retval: "+ rb.getRetVal());
			/*debe retornar esto:
			 * Read Bytes : 4 retval: 1
			  	0 2 11 0  
			 */
			System.out.println("Resultado del close: " + rb.getReadBytes()[1+HEADER_LENGTH]);
		}

		// tener en cuenta esta clase para manejo de bytes MappedByteBuffer
		else {
			System.out.println("USB Operation Failed\r\n");
			System.out.println("return: " + rb.getReadBytes() + " length:" + rb.getLength() + " ret:" +rb.getRetVal() );
		}
		// Let's close the data pipes since we have nothing left to do..
		try {

			UsbDllAdapter.MPUSBClose(myOutPipe);
			UsbDllAdapter.MPUSBClose(myInPipe);
		}
		catch (Exception e){
			System.out.println("error a hacer el close");
			System.out.println(e.getMessage());
		}
		myOutPipe = myInPipe = INVALID_HANDLE_VALUE;
	}


	static void ReadTemp() {
		// First we need to open data pipes...
		//TODO sacar hardcode de selection
		int selection=0; 
		String out_pipe= "\\MCHP_EP1";
		String in_pipe= "\\MCHP_EP1";
		int myOutPipe=-1;
		int myInPipe=-1;
		int rawval, rawtemp;
		float degCtemp;
		try {
			myOutPipe = UsbDllAdapter.MPUSBOpen(selection,vid_pid,out_pipe,MP_WRITE,0);
			myInPipe = UsbDllAdapter.MPUSBOpen(selection,vid_pid,out_pipe,MP_READ,0);
		} catch (Exception e){
			System.out.println(e.getMessage());
		}
		if(myOutPipe == INVALID_HANDLE_VALUE || myInPipe == INVALID_HANDLE_VALUE)
		{
			System.out.println("Failed to open data pipes.\r\n");
			return;
		}//end if

		System.out.println("myOutPipe: "+ myOutPipe + " myInPipe:" + myInPipe);

	
		int RecvLength=6;
		int READ_VERSION=0;
		StringBuffer receive_buf = new StringBuffer(64);
		StringBuffer send_buf= new StringBuffer(64);
	
		send_buf.append((char)0x10);		//HEADER
		send_buf.append((char)0x00);		//HEADER
		send_buf.append((char)0x00);		//HEADER

		send_buf.append((char)0x34);
		send_buf.append((char)0x02);

		//System.out.println(send_buf.toString());
		ReadBytes rb =SendReceivePacket(myOutPipe,myInPipe,send_buf.toString().getBytes(),send_buf.toString().length(),RecvLength,1000,5000);
		if(rb.getRetVal() == 1)
		{
			/*System.out.println("Read Bytes : "+ rb.getLength()+ " retval: "+ rb.getRetVal());
			for (int i =0 ; i<rb.getLength() ; i++){
				System.out.print((int)rb.getReadBytes()[i]);
				System.out.print(" ");
			}
			System.out.println(" ");*/

			rawval = rb.getReadBytes()[1+HEADER_LENGTH] + ((rb.getReadBytes()[2+HEADER_LENGTH])<<8);


			rawtemp = (rawval)>>3;
			degCtemp = (float) (rawtemp * 0.0625);

			System.out.println("La temperatura es: " + degCtemp);
		}

		// tener en cuenta esta clase para manejo de bytes MappedByteBuffer
		else {
			System.out.println("USB Operation Failed\r\n");
			System.out.println("return: " + rb.getReadBytes() + " length:" + rb.getLength() + " ret:" +rb.getRetVal() );
		}
		// Let's close the data pipes since we have nothing left to do..
		try {

			UsbDllAdapter.MPUSBClose(myOutPipe);
			UsbDllAdapter.MPUSBClose(myInPipe);
		}
		catch (Exception e){
			System.out.println("error a hacer el close");
			System.out.println(e.getMessage());
		}
		myOutPipe = myInPipe = INVALID_HANDLE_VALUE;
	}
	static void moverMotor(char sentido) {
		// First we need to open data pipes...
		//TODO sacar hardcode de selection
		int selection=0; 
		String out_pipe= "\\MCHP_EP1";
		int myOutPipe=-1;
		int myInPipe=-1;
		try {
			myOutPipe = UsbDllAdapter.MPUSBOpen(selection,vid_pid,out_pipe,MP_WRITE,0);
			myInPipe = UsbDllAdapter.MPUSBOpen(selection,vid_pid,out_pipe,MP_READ,0);
		} catch (Exception e){
			System.out.println(e.getMessage());
		}
		if(myOutPipe == INVALID_HANDLE_VALUE || myInPipe == INVALID_HANDLE_VALUE)
		{
			System.out.println("Failed to open data pipes.\r\n");
			return;
		}//end if

		System.out.println("myOutPipe: "+ myOutPipe + " myInPipe:" + myInPipe);
		int RecvLength=4;
		int READ_VERSION=0;
		StringBuffer receive_buf = new StringBuffer(64);
		StringBuffer send_buf= new StringBuffer(64);
	
		send_buf.append((char)0x08);		//HEADER
		send_buf.append((char)0x00);		//HEADER
		send_buf.append((char)0x00);		//HEADER

		send_buf.append((char)0x01);
		send_buf.append(sentido);

		//System.out.println(send_buf.toString());
		ReadBytes rb =SendReceivePacket(myOutPipe,myInPipe,send_buf.toString().getBytes(),send_buf.toString().length(),RecvLength,1000,5000);
		if(rb.getRetVal() == 1)
		{
			System.out.println("Read Bytes : "+ rb.getLength()+ " retval: "+ rb.getRetVal());
			for (int i =0 ; i<rb.getLength() ; i++){
				System.out.print((int)rb.getReadBytes()[i]);
				System.out.print(" ");
			}
			System.out.println(" ");

			}

		// tener en cuenta esta clase para manejo de bytes MappedByteBuffer
		else {
			System.out.println("USB Operation Failed\r\n");
			System.out.println("return: " + rb.getReadBytes() + " length:" + rb.getLength() + " ret:" +rb.getRetVal() );
		}
		// Let's close the data pipes since we have nothing left to do..
		try {

			UsbDllAdapter.MPUSBClose(myOutPipe);
			UsbDllAdapter.MPUSBClose(myInPipe);
		}
		catch (Exception e){
			System.out.println("error a hacer el close");
			System.out.println(e.getMessage());
		}
		myOutPipe = myInPipe = INVALID_HANDLE_VALUE;
	}	
	
	static void ReadMessage() {
		// First we need to open data pipes...
		//TODO sacar hardcode de selection
		int selection=0; 
		String out_pipe= "\\MCHP_EP1";
		String in_pipe= "\\MCHP_EP1";
		int myOutPipe=-1;
		int myInPipe=-1;
		StringBuffer mensaje = new StringBuffer(8);
		try {
			myOutPipe = UsbDllAdapter.MPUSBOpen(selection,vid_pid,out_pipe,MP_WRITE,0);
			myInPipe = UsbDllAdapter.MPUSBOpen(selection,vid_pid,out_pipe,MP_READ,0);
		} catch (Exception e){
			System.out.println(e.getMessage());
		}
		if(myOutPipe == INVALID_HANDLE_VALUE || myInPipe == INVALID_HANDLE_VALUE)
		{
			System.out.println("Failed to open data pipes.\r\n");
			return;
		}//end if

		System.out.println("myOutPipe: "+ myOutPipe + " myInPipe:" + myInPipe);

	
		int RecvLength=12; //<header:3><comando:1><mensaje:8>
		int READ_VERSION=0;
		StringBuffer receive_buf = new StringBuffer(64);
		StringBuffer send_buf= new StringBuffer(64);
	
		send_buf.append((char)0x08);		//HEADER
		send_buf.append((char)0x00);		//HEADER
		send_buf.append((char)0x00);		//HEADER

		send_buf.append((char)0x55);
		//send_buf.append((char)0x02);

		//System.out.println(send_buf.toString());
		ReadBytes rb =SendReceivePacket(myOutPipe,myInPipe,send_buf.toString().getBytes(),send_buf.toString().length(),RecvLength,1000,5000);
		if(rb.getRetVal() == 1)
		{
			System.out.println("Read Bytes : "+ rb.getLength()+ " retval: "+ rb.getRetVal());
			for (int i =0 ; i<rb.getLength() ; i++){
				System.out.print((int)rb.getReadBytes()[i]);
				System.out.print(" ");
			}
			System.out.println(" ");

			//mensaje.append(rb.getReadBytes()[HEADER_LENGTH]);
			mensaje.append((char)rb.getReadBytes()[1+HEADER_LENGTH]);
			mensaje.append((char)rb.getReadBytes()[2+HEADER_LENGTH]);
			mensaje.append((char)rb.getReadBytes()[3+HEADER_LENGTH]);
			mensaje.append((char)rb.getReadBytes()[4+HEADER_LENGTH]);
			mensaje.append((char)rb.getReadBytes()[5+HEADER_LENGTH]);
			mensaje.append((char)rb.getReadBytes()[6+HEADER_LENGTH]);
			mensaje.append((char)rb.getReadBytes()[7+HEADER_LENGTH]);
			//mensaje.append((char)rb.getReadBytes()[8+HEADER_LENGTH]);
			
			System.out.println("el mensaje recibido es:");	
			System.out.println(mensaje.toString());
		}

		// tener en cuenta esta clase para manejo de bytes MappedByteBuffer
		else {
			System.out.println("USB Operation Failed\r\n");
			System.out.println("return: " + rb.getReadBytes() + " length:" + rb.getLength() + " ret:" +rb.getRetVal() );
		}
		// Let's close the data pipes since we have nothing left to do..
		try {

			UsbDllAdapter.MPUSBClose(myOutPipe);
			UsbDllAdapter.MPUSBClose(myInPipe);
		}
		catch (Exception e){
			System.out.println("error a hacer el close");
			System.out.println(e.getMessage());
		}
		myOutPipe = myInPipe = INVALID_HANDLE_VALUE;
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub
		int res = 255;
		try {
			res = UsbDllAdapter.MPUSBGetDLLVersion();
		} catch (Exception e){
			System.out.println(e.getMessage());
		}
		System.out.println("Version de la dll: " + res/65536 + "." + res%65536 );
		try {
			res = UsbDllAdapter.MPUSBGetDeviceCount(vid_pid);
		} catch (Exception e){
			System.out.println(e.getMessage());
		}
		System.out.println("Cantidad de dispositivos conectados: " +res );


		String out_pipe= "\\MCHP_EP1";
		String in_pipe= "\\MCHP_EP1";

		int outPipe = -1;
		try {
			outPipe = UsbDllAdapter.MPUSBOpen(0,vid_pid,out_pipe,MP_WRITE,0);
		} catch (Exception e){
			System.out.println("FALLO el open");
			System.out.println(e.getMessage());
		}
		if (outPipe!=-1){
			System.out.println("Funciono bien el open");
		}
		else {
			System.out.println("Funciono MAL el open");
		}

		/*
		int inPipe = -1;
		try {
			inPipe = UsbDllAdapter.MPUSBOpen(0,vid_pid,in_pipe,MP_READ,0);
		} catch (Exception e){
			System.out.println("FALLO el open");
			System.out.println(e.getMessage());
		}
		if (inPipe!=-1){
			System.out.println("Funciono bien el open");
		}
		else {
			System.out.println("Funciono MAL el open");
		}
		 */
		try {
			res = UsbDllAdapter.MPUSBClose(outPipe);
		} catch (Exception e){
			System.out.println("FALLO el close");
			System.out.println(e.getMessage());
		}
		if (res==1){
			System.out.println("anduvo bien el close");
		}
		else {
			System.out.println("anduvo MAL el close");
		}
		
		//OpenMotor();
		//GetModulesSize();
		for(int i = 0; i < GetModulesSize(); i++){
			GetModuleName(i);
		}
		
		//OpenTemp();
		char sentido = (char)0x02;
		//moverMotor(sentido);
		//OpenBoot();
		//GetUSBDemoFWVersionH1();
		//GetUSBDemoFWVersionH2();
		//ReadTemp();
		//ReadMessage();
		//Close(1);

	}


	private static void GetModuleName(int line) {
		// First we need to open data pipes...
		//TODO sacar hardcode de selection
		StringBuffer mensaje = new StringBuffer(8);
		int selection=0; 
		String out_pipe= "\\MCHP_EP1";
		String in_pipe= "\\MCHP_EP1";
		int myOutPipe=-1;
		int myInPipe=-1;
		try {
			myOutPipe = UsbDllAdapter.MPUSBOpen(selection,vid_pid,out_pipe,MP_WRITE,0);
			myInPipe = UsbDllAdapter.MPUSBOpen(selection,vid_pid,out_pipe,MP_READ,0);
		} catch (Exception e){
			System.out.println(e.getMessage());
		}
		if(myOutPipe == INVALID_HANDLE_VALUE || myInPipe == INVALID_HANDLE_VALUE)
		{
			System.out.println("Failed to open data pipes.\r\n");
			return;
		}//end if

		System.out.println("myOutPipe: "+ myOutPipe + " myInPipe:" + myInPipe);
		// The default demo firmware application has a defined application
		// level protocol.
		// To read the firmware version, the host must send the READ_VERSION
		// command which is defined as 0x00, follows by the length of the
		// expected result, in this case is 2 bytes, major version, and minor
		// version.
		// i.e. <READ_VERSION><0x02>
		//
		// The response packet from the board has the following format:
		// <READ_VERSION><0x02><MINOR_VER><MAJOR_VER>

		// The receive buffer size must be equal to or larger than the maximum
		// endpoint size it is communicating with. In this case, 64 bytes.

		//BYTE send_buf[64],receive_buf[64];
		int RecvLength=12;
		int READ_VERSION=0;
		StringBuffer receive_buf = new StringBuffer(64);
		StringBuffer send_buf= new StringBuffer(64);
		//send_buf[0] = READ_VERSION;      // Command
		//send_buf[1] = 0x02;              // Expected length of the result

		send_buf.append((char)0x00);		//HEADER
		send_buf.append((char)0x04);		//HEADER
		send_buf.append((char)0x00);		//HEADER

		send_buf.append((char)0x06);
		send_buf.append((char)line);
    	//System.out.println(send_buf.toString());
		ReadBytes rb =SendReceivePacket(myOutPipe,myInPipe,send_buf.toString().getBytes(),send_buf.toString().length(),RecvLength,1000,1000);
		if(rb.getRetVal() == 1)
		{
			System.out.println("Read Bytes : "+ rb.getLength()+ " retval: "+ rb.getRetVal());
			for (int i =0 ; i<rb.getLength() ; i++){
				System.out.print((int)rb.getReadBytes()[i]);
				System.out.print(" ");
			}
			System.out.println(" ");
			mensaje.append((char)rb.getReadBytes()[1+HEADER_LENGTH]);
			mensaje.append((char)rb.getReadBytes()[2+HEADER_LENGTH]);
			mensaje.append((char)rb.getReadBytes()[3+HEADER_LENGTH]);
			mensaje.append((char)rb.getReadBytes()[4+HEADER_LENGTH]);
			mensaje.append((char)rb.getReadBytes()[5+HEADER_LENGTH]);
			mensaje.append((char)rb.getReadBytes()[6+HEADER_LENGTH]);
			mensaje.append((char)rb.getReadBytes()[7+HEADER_LENGTH]);
			//mensaje.append((char)rb.getReadBytes()[8+HEADER_LENGTH]);
			
			System.out.println("el mensaje recibido es:");	
			System.out.println(mensaje.toString());

		}

		// tener en cuenta esta clase para manejo de bytes MappedByteBuffer
		else {
			System.out.println("USB Operation Failed\r\n");
			System.out.println("return: " + rb.getReadBytes() + " length:" + rb.getLength() + " ret:" +rb.getRetVal() );
		}
		// Let's close the data pipes since we have nothing left to do..
		try {

			UsbDllAdapter.MPUSBClose(myOutPipe);
			UsbDllAdapter.MPUSBClose(myInPipe);
		}
		catch (Exception e){
			System.out.println("error a hacer el close");
			System.out.println(e.getMessage());
		}
		myOutPipe = myInPipe = INVALID_HANDLE_VALUE;
				
	}


	private static int GetModulesSize() {		
		// First we need to open data pipes...
		//TODO sacar hardcode de selection
		int selection=0; 
		String out_pipe= "\\MCHP_EP1";
		String in_pipe= "\\MCHP_EP1";
		int myOutPipe=-1;
		int myInPipe=-1;
		try {
			myOutPipe = UsbDllAdapter.MPUSBOpen(selection,vid_pid,out_pipe,MP_WRITE,0);
			myInPipe = UsbDllAdapter.MPUSBOpen(selection,vid_pid,out_pipe,MP_READ,0);
		} catch (Exception e){
			System.out.println(e.getMessage());
		}
		if(myOutPipe == INVALID_HANDLE_VALUE || myInPipe == INVALID_HANDLE_VALUE)
		{
			System.out.println("Failed to open data pipes.\r\n");
			return -1;
		}//end if

		System.out.println("myOutPipe: "+ myOutPipe + " myInPipe:" + myInPipe);

		// The default demo firmware application has a defined application
		// level protocol.
		// To read the firmware version, the host must send the READ_VERSION
		// command which is defined as 0x00, follows by the length of the
		// expected result, in this case is 2 bytes, major version, and minor
		// version.
		// i.e. <READ_VERSION><0x02>
		//
		// The response packet from the board has the following format:
		// <READ_VERSION><0x02><MINOR_VER><MAJOR_VER>

		// The receive buffer size must be equal to or larger than the maximum
		// endpoint size it is communicating with. In this case, 64 bytes.

		//BYTE send_buf[64],receive_buf[64];
		int RecvLength=5;
		int READ_VERSION=0;
		StringBuffer receive_buf = new StringBuffer(64);
		StringBuffer send_buf= new StringBuffer(64);
		//send_buf[0] = READ_VERSION;      // Command
		//send_buf[1] = 0x02;              // Expected length of the result

		send_buf.append((char)0x00);		//HEADER
		send_buf.append((char)0x04);		//HEADER
		send_buf.append((char)0x00);		//HEADER

		send_buf.append((char)0x05);
    	//System.out.println(send_buf.toString());
		ReadBytes rb =SendReceivePacket(myOutPipe,myInPipe,send_buf.toString().getBytes(),send_buf.toString().length(),RecvLength,1000,1000);
		if(rb.getRetVal() == 1)
		{
			System.out.println("Read Bytes : "+ rb.getLength()+ " retval: "+ rb.getRetVal());
			for (int i =0 ; i<rb.getLength() ; i++){
				System.out.print((int)rb.getReadBytes()[i]);
				System.out.print(" ");
			}
			System.out.println(" ");
			//System.out.println("String: " + rb.getString() +" Read Bytes : "+ rb.getLength()+ " retval: "+ rb.getRetVal());
			/*debe retornar esto:
			 * Read Bytes : 4 retval: 1
			  	0 2 11 0  
			 */
			System.out.println("Numero de modulos cargados: " + rb.getReadBytes()[1+HEADER_LENGTH]);
		}

		// tener en cuenta esta clase para manejo de bytes MappedByteBuffer
		else {
			System.out.println("USB Operation Failed\r\n");
			System.out.println("return: " + rb.getReadBytes() + " length:" + rb.getLength() + " ret:" +rb.getRetVal() );
		}
		// Let's close the data pipes since we have nothing left to do..
		try {

			UsbDllAdapter.MPUSBClose(myOutPipe);
			UsbDllAdapter.MPUSBClose(myInPipe);
		}
		catch (Exception e){
			System.out.println("error a hacer el close");
			System.out.println(e.getMessage());
		}
		myOutPipe = myInPipe = INVALID_HANDLE_VALUE;

		return (int)rb.getReadBytes()[1+HEADER_LENGTH];
	}

}
